---
obsidianUIMode: preview
---

Sometimes you need a monster right now but you don't have the right one handy. Maybe the creature you're imagining doesn't exist in any given book of published monsters, or you simply don't have the time to look it up. Maybe you're in the middle of your game and want some quick statistics for a creature you didn't think you'd need. For all these problems, this section offers solutions.

The core tool for building a quick monster for a 5e game is the Monster Statistics by Challenge Rating table, which offers you a set of statistics that can be used to build and run a quick monster of any challenge rating (CR). You then have two paths for customizing a monster built from these baseline statistics—with flavor and description during the game, or with a refinement of the creature's mechanics.

It's worth your time to review and understand how this table works before you start using it in your game. Read the column descriptions. Understand the relationship between a monster's challenge rating and equivalent character level. Once you've internalized how this table works, you can use it in seconds to build a monster and throw that foe into your game.

## Column Descriptions

The table includes the following columns, which will become more familiar to you as you build your monsters.

***Monster CR.*** The challenge ratings presented in the CR column are the baseline measure to determine the relative difficulty of a monster in combat. You'll almost always reference this column first when building a quick monster.

***Equivalent Character Level.*** This column describes the roughly equivalent level of a single character facing a single monster of this challenge rating in a hard encounter. This gives you a quick way to determine how difficult this monster will be when facing characters of a particular level.

As you can see from the table, matching character level to challenge rating isn't a simple mathematical process. There are a number of character levels missing from the table where certain challenge ratings represent a large jump in how tough a monster is.

***AC/DC.*** This column indicates the typical Armor Class of a monster of the indicated challenge rating. It also describes the typical Difficulty Class if this monster uses a DC for any of their attacks or other features.

***Hit Points.*** This column offers the baseline hit points of a monster of a given challenge rating. Feel free to add or subtract hit points within the suggested range based on the monster's in-world features or physiology, or the pacing you want to maintain during a battle.

***Proficient Ability Bonus.*** This column gives the expected bonus for abilities with which the monster is proficient, adding the monster's ability score modifier and proficiency bonus together. This number can be used as an attack bonus, or as a bonus for proficient saving throws and ability checks. (Ability-based modifiers without proficiency are fixed values between −2 and +4, based on the monster's story.)

***Damage per Round.*** This column contains the total expected damage that a monster can deal in a round. Higher-CR monsters typically split this total damage among a number of attacks, instead of doing one big attack that either deals a tremendous amount of damage or misses completely. If a single effect targets two or more characters, such as a fiery breath weapon, the damage for that effect should be half the indicated number.

***Number of Attacks.*** This column notes the number of attacks a monster of a particular challenge rating typically makes per round. The damage per round from the previous column is divided among these multiple attacks in the following column.

***Damage per Attack.*** This column shows the baseline amount of damage a monster deals per attack when using the default number of attacks in the previous column. It includes both average damage and a dice equation.

***Example Monsters.*** This column offers example monsters for each challenge rating. This can help you gauge where your monster fits among a sampling of existing 5e monsters.

## Building a Monster

With the Monster Statistics by Challenge Rating table at hand, you can use the following quick steps to build a custom monster from scratch. The first four steps alone let you easily create a monster ready to run in your game. The optional steps that follow then let you fill out the monster's details and custom mechanics as desired.

### Step 1: Determine Challenge Rating

Begin by determining the challenge rating for your quick monster based on that creature's fiction in the world. When considering the challenge rating of a custom monster, you might compare them to existing creatures on the table. If the in-world power of your monster compares well to a skeleton, the monster might have a challenge rating of 1/4. If they're more like a fire giant, they might have a challenge rating of 9. Look at the list of example monsters and ask yourself which monster makes the best comparison to yours. Then assign your creature that monster's challenge rating.

### Alternatively, What Challenge Rating Do You Need?

You might also want to choose a challenge rating based on the level of the characters, using the Equivalent Character Level column of the table. If you want an encounter with four monsters who are roughly equal in power to four characters, this column lets you figure out those monsters' statistics. It also helps you build NPCs—knights, mages, thieves, and so forth—intended to be a match for characters of a particular level.

### Step 2: Write Down the Baseline Statistics

Once you've determined a challenge rating for your monster, write down their statistics. You might jot them on an index card, in a text editor on your computer, or wherever you keep notes for your adventures and campaigns. You might end up customizing those statistics, though, so be ready to change them.

### Step 3: Determine Proficient Abilities

Next, determine which abilities—Strength, Dexterity, Constitution, Intelligence, Wisdom, or Charisma—a monster is proficient in, using the Proficient Ability Bonus column on the table. This sets up the bonus a monster has when using any ability with which they're proficient, and is largely based on the monster's story. A big, beefy monster might be proficient in skills or saving throws involving Strength and Constitution. A mastermind monster might be proficient in Wisdom- and Intelligence-based skills and saving throws. A fast monster might be proficient in Dexterity (Acrobatics) checks and Dexterity saving throws, while an otherworldly monster might be proficient in Charisma-based skills and saves.

The bonus indicated in the table is what the monster uses to make saving throws and ability checks with those proficient abilities. Just remember that the number on the table already includes a monster's proficiency bonus, in addition to their ability score modifier.

### Step 4: Determine Remaining Abilities

Next, you can determine the modifier (either a penalty or a bonus) that a monster uses for their nonproficient abilities. This is for all the ability checks and saving throws a monster isn't great at, and can be determined by asking yourself how strong a monster feels in those abilities. The bonus can range anywhere from −2 to +4, and is independent of a monster's challenge rating. Even a high-challenge monster might have a lousy Dexterity saving throw. When in doubt, or to speed things up, use a modifier of +0 for these nonproficient abilities. You can always change this during the game if a higher or lower number makes sense.

A creature's Dexterity modifier is also used to determine their initiative modifier. Or you can skip your improvised creature's initiative roll and use a static initiative of 12.

### You're Ready to Go

At this point, you have enough information on hand to run your monster in a game, with little else needed. However, you can also continue with a few more quick steps to further customize your monster, making them more distinct.

## Monster Statistics by Challenge Rating

| CR  | Eqv Char Lvl | AC/DC | HP            | Prof Bonus | Damage per Round | # Attacks | Damage         | Example Monster                             |
| --- | ------------ | ----- | ------------- | ---------- | ---------------- | --------- | -------------- | ------------------------------------------- |
| 0   | < 1          | 10    | 3 (2-4)       | +2         | 2                | 1         | 2 (1d4)        | Commoner, rat, spider                       |
| 1/8 | < 1          | 11    | 9 (7-11)      | +3         | 3                | 1         | 4 (1d6 + 1)    | Bandit, cultist, giant rat                  |
| 1/4 | 1            | 11    | 13 (10-16)    | +3         | 5                | 1         | 5 (1d6 + 2)    | Acolyte, skeleton, wolf                     |
| 1/2 | 2            | 12    | 22 (17-28)    | +4         | 8                | 2         | 4 (1d4 + 2)    | Black bear, scout, shadow                   |
| 1   | 3            | 12    | 33 (25-41)    | +5         | 12               | 2         | 6 (1d8 + 2)    | Dire wolf, specter, spy                     |
| 2   | 5            | 13    | 45 (34-56)    | +5         | 17               | 2         | 9 (2d6 + 2)    | Ghast, ogre, priest                         |
| 3   | 7            | 13    | 65 (49-81)    | +5         | 23               | 2         | 12 (2d8 + 3)   | Knight, mummy, werewolf                     |
| 4   | 9            | 14    | 84 (64-106)   | +6         | 28               | 2         | 14 (3d8 + 1)   | Ettin, ghost                                |
| 5   | 10           | 15    | 95 (71-119)   | +7         | 35               | 3         | 12 (3d6 + 2)   | Elemental, gladiator, vampire spawn         |
| 6   | 11           | 15    | 112 (84-140)  | +7         | 41               | 3         | 14 (3d6 + 4)   | Mage, medusa, wyvern                        |
| 7   | 12           | 15    | 130 (98-162)  | +7         | 47               | 3         | 16 (3d8 + 3)   | Stone giant, young black dragon             |
| 8   | 13           | 15    | 136 (102-170) | +7         | 53               | 3         | 18 (3d10 + 2)  | Assassin, frost giant                       |
| 9   | 15           | 16    | 145 (109-181) | +8         | 59               | 3         | 19 (3d10 + 3)  | Bone devil, fire giant, young blue dragon   |
| 10  | 16           | 17    | 155 (116-194) | +9         | 65               | 4         | 16 (3d8 + 3)   | Stone golem, young red dragon               |
| 11  | 17           | 17    | 165 (124-206) | +9         | 71               | 4         | 18 (3d10 + 2)  | Djinni, efreeti, horned devil               |
| 12  | 18           | 17    | 175 (131-219) | +9         | 77               | 4         | 19 (3d10 + 3)  | Archmage, erinyes                           |
| 13  | 19           | 18    | 184 (138-230) | +10        | 83               | 4         | 21 (4d8 + 3)   | Adult white dragon, storm giant, vampire    |
| 14  | 20           | 19    | 196 (147-245) | +11        | 89               | 4         | 22 (4d10)      | Adult black dragon, ice devil               |
| 15  | > 20         | 19    | 210 (158-263) | +11        | 95               | 5         | 19 (3d10 + 3)  | Adult green dragon, mummy lord, purple worm |
| 16  | > 20         | 19    | 229 (172-286) | +11        | 101              | 5         | 21 (4d8 + 3)   | Adult blue dragon, iron golem, marilith     |
| 17  | > 20         | 20    | 246 (185-308) | +12        | 107              | 5         | 22 (3d12 + 3)  | Adult red dragon                            |
| 18  | > 20         | 21    | 266 (200-333) | +13        | 113              | 5         | 23 (4d10 + 1)  | Demilich                                    |
| 19  | > 20         | 21    | 285 (214-356) | +13        | 119              | 5         | 24 (4d10 + 2)  | Balor                                       |
| 20  | > 20         | 21    | 300 (225-375) | +13        | 132              | 5         | 26 (4d12)      | Ancient white dragon, pit fiend             |
| 21  | > 20         | 22    | 325 (244-406) | +14        | 150              | 5         | 30 (4d12 + 4)  | Ancient black dragon, lich, solar           |
| 22  | > 20         | 23    | 350 (263-438) | +15        | 168              | 5         | 34 (4d12 + 8)  | Ancient green dragon                        |
| 23  | > 20         | 23    | 375 (281-469) | +15        | 186              | 5         | 37 (6d10 + 4)  | Ancient blue dragon, kraken                 |
| 24  | > 20         | 23    | 400 (300-500) | +15        | 204              | 5         | 41 (6d10 + 8)  | Ancient red dragon                          |
| 25  | > 20         | 24    | 430 (323-538) | +16        | 222              | 5         | 44 (6d10 + 11) |                                             |
| 26  | > 20         | 25    | 460 (345-575) | +17        | 240              | 5         | 48 (6d10 + 15) |                                             |
| 27  | > 20         | 25    | 490 (368-613) | +17        | 258              | 5         | 52 (6d10 + 19) |                                             |
| 28  | > 20         | 25    | 540 (405-675) | +17        | 276              | 5         | 55 (6d10 + 22) |                                             |
| 29  | > 20         | 26    | 600 (450-750) | +18        | 294              | 5         | 59 (6d10 + 26) |                                             |
| 30  | > 20         | 27    | 666 (500-833) | +19        | 312              | 5         | 62 (6d10 + 29) | Tarrasque                                   |

### Optional Step: Consider Armor Class

Though the Monster Statistics by Challenge Rating table offers a value for Armor Class that increases with challenge rating, you can modify a monster's Armor Class further based on their story. A big beefy titan set up as a CR 16 monster might still be easy to hit—maybe with an Armor Class of 14.

It's easiest to think of Armor Class on a scale of 10 to 20, with 10 being the equivalent of an unarmored opponent with no Dexterity bonus, and 20 being an opponent wearing plate armor with a shield. (Armor Class can go above 20 or below 10, though.)

Keep in mind that missing an opponent isn't much fun for a player. Lower-AC opponents, even those with more hit points, are often more fun to fight than high-AC opponents with fewer hit points.

### Optional Step: Customize Attacks

The table includes a recommended number of attacks for a monster, an attack bonus, and the amount of damage those attacks should deal. If desired, tailor this damage to fit the monster's story. Choose a creature's damage type, such as fire for a flaming Greatsword attack, or necrotic for a Death Blast attack. You can also mix up multiple damage types, so that a CR 10 hell knight might have a Longsword attack dealing both slashing and fire damage.

Consider the ranged attacks a monster might have as well. You can use the same attack bonus, number of attacks, and damage. Or you could give a creature weaker ranged attacks (attacking once instead of twice, for example). Depending on the creature's story, the flavor of those attacks might be physical (hurling javelins or rocks) or arcane (firing energy blasts).

To further customize a monster, you can divide up their total damage per round into a different number of attacks than indicated on the table, if that makes sense for the monster's story. (As noted above, for attacks that target two or more opponents, use half the indicated damage.)

### Optional Step: Further Modify Statistics

Depending on the story of your monster, you can make general adjustments to their baseline statistics however you see fit. For example, you might lower a monster's hit points and increase the damage they deal to create a dangerous foe who drops out of the fight quickly. However, always consider whether such changes make a combat encounter more fun to play. It might make sense to create a monster with high hit points and a higher Armor Class who deals less damage, thinking that those two things balance out. But fighting such a monster can easily become a slog. Likewise, a monster with significantly fewer hit points that deals high damage might end up being inadvertently deadly if too many characters roll low on attacks, or could feel pointless if the monster is killed too quickly.

### Optional Step: Add Monster Types and Features

To further flesh out your monster, add monster types and features found for monsters similar to the one you're building such as extra weapon damage types, breath weapons, auras, damage shields, and other traits and features that better define your monster in the story and situation.

## Using the Table with Published Monsters

While the Monster Statistics by Challenge Rating table is intended to let you build monsters from scratch, it can easily be used as a reference to better understand how a published monster might act in combat. If a published CR 4 monster has 30 hit points but deals 35 damage per round, you can see from the table that their hit points are low but their damage is high compared to the creature's baseline challenge rating. Such a monster hits hard for their challenge rating, but when they're hit in turn, they go down fast.
